unit Form;

{$I delphi.inc}

interface

uses
  Windows, Messages, SysUtils, {$IFDEF D6OR7}Variants, {$ENDIF}Classes, Graphics, Controls, Forms,
  Dialogs, jsintf, StdCtrls, socket, ExtCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Label1: TLabel;
    Bevel1: TBevel;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    FEngine: TJSEngine;
    FScript: TJSScript;
    FSocket: TMyClientSocket;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.FormCreate(Sender: TObject);
begin
  FEngine := TJSEngine.Create(40000);
  FScript := TJSScript.Create;
  FSocket := TMyClientSocket.Create;

  FScript.LoadRaw('script.js');
  FScript.Execute(FEngine);

  FEngine.Global.AddNativeObject(Button1, 'button');
  FEngine.Global.AddNativeObject(FSocket, 'socket');
  FEngine.Global.AddNativeObject(Label1, 'label');
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  FEngine.Free;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  FEngine.Global.Evaluate('load()');
end;

end.
